<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Ultimate_AI_Payments
{
    private $history_manager;
    private $user_manager;
    private $PAYMENT_MODULE;

    public function __construct()
    {
        add_action('wp_ajax_ultimate_ai_update_payment_methods', [$this, 'update_payment_methods']);
        add_action('wp_ajax_ultimate_ai_payment_methods', [$this, 'payment_methods']);
        add_action('wp_ajax_ultimate_ai_available_payment_methods', [$this, 'available_payment_methods']);
        add_action('wp_ajax_ultimate_ai_payment_success_response', [$this, 'ultimate_ai_payment_success_response']);
        add_action('wp_ajax_create_payments', [$this, 'init_payment']);
        add_action( 'woocommerce_thankyou', [ $this, 'ultimate_ai_order_redirect_success'] );
        $this->PAYMENT_MODULE = new Ultimate_AI_Payments_Module();
    }
 
    function ultimate_ai_order_redirect_success( $order_id ){
        $order = wc_get_order( $order_id );
        $pricing_id = WC()->session->get( 'pricing_id' );
        $url = $this->PAYMENT_MODULE->createSuccessUrl( 'woocommerce', $pricing_id, $order_id );
        if ( ! $order->has_status( 'failed' ) && isset( $pricing_id ) ) {
            wp_safe_redirect( $url );
            exit;
        }
    }

    public function ultimate_ai_payment_success_response()
    {
        $parsed = wp_parse_url($_POST['url_string']);

        wp_parse_str($parsed['query'], $parsed_args);

        $res = $this->PAYMENT_MODULE->prepareSuccessResponse($parsed_args);
        wp_send_json($res, 200);
    }

    public function init_payment()
    {
        $this->PAYMENT_MODULE->setPaymentdata($_POST['payment_data']);
        $checkout_url = $this->PAYMENT_MODULE->securedCheckout();

        wp_send_json($checkout_url, 200);
    }

    public function update_payment_methods()
    {
        restrict_req_for_admin();
        $value = Ultimate_AI_Filter_Controller($_POST['methods']);

        $res = update_option('ultimate_ai_payment_method', $value, true);
        wp_send_json($res, 200);
    }

    public function payment_methods()
    {
        $res = get_option('ultimate_ai_payment_method', []);
        wp_send_json($res, 200);
    }

    public function available_payment_methods()
    {
        $res = $this->PAYMENT_MODULE->active_payment_methods();
        wp_send_json($res, 200);
    }
}
new Ultimate_AI_Payments();
